
#include "VideoHelpers.h"
#include <Hermes.h>
#include <H_Conv.h>
#include "bitmapfont.h"
#include <stdlib.h>
#include <string.h>

#include <fb.h>

HermesHandle converter;
HermesHandle clearer;
HermesFormat *form;

int bfInit(char *fontfilename, FONT *f)
{
	int x,y,i;
	
	//load jpeg font file
	JPEG fontimg;
	HermesFormat *imgform;

	printk("Loading font jpg\n");
	if(!LoadJpeg(fontfilename, &fontimg))
		return 0;
	
	f->w = fontimg.nWidth / 16;
	f->h = fontimg.nHeight / 14;
	f->bpp = 32;

	//init letter pointers to 0, so bfFree doesnt try and free them
	for(i=0;i<224;i++)
		f->letters[i]=(char*)0;
	
	
	printk("Hermes_FormatNew: %d\n", fontimg.nBytesPerPixel*8);
	imgform = Hermes_FormatNew(fontimg.nBytesPerPixel*8,0xFF0000,0x00FF00,0x0000FF,0,0);
	if(!imgform)
	{
		free(fontimg.pBitmapData);
		return 0;
	}


	
	i=0;
	for(y=0;y<14;y++)
	{
		for(x=0;x<16;x++)
		{
			f->letters[i] = malloc(f->w*f->h*f->bpp);
			if(!f->letters[i])
			{
				printk("malloc failed!\n");
				Hermes_FormatFree(imgform);
				free(fontimg.pBitmapData);
				bfFree(f);
				return 0;
			}
			if(!Hermes_ConverterRequest(converter,imgform,form))
			{
				printk("Hermes_ConverterRequest failed!\n");
				Hermes_FormatFree(imgform);
				free(fontimg.pBitmapData);
				bfFree(f);
				return 0;
			}
			if(!Hermes_ConverterCopy(converter,
					fontimg.pBitmapData,
					f->w*x,f->h*y,
					f->w, f->h,
					fontimg.nWidth*fontimg.nBytesPerPixel,
	
					f->letters[i],
					0,0,
					f->w,f->h,
					f->w*f->bpp))
			{
				printk("Hermes_ConverterCopy failed!\n");
				Hermes_FormatFree(imgform);
				free(fontimg.pBitmapData);
				bfFree(f);
				return 0;
			}

			i++;
		}
	}
	printk("\nFreeing resources\n");
	
	Hermes_FormatFree(imgform);
	free(fontimg.pBitmapData);
	return 1;
}

void bfFree(FONT *f)
{
	int i;
	f->h=0;
	f->w=0;
	f->bpp=0;
	for(i=0;i<224;i++)
		if(f->letters[i])
			free(f->letters[i]);
}

int bfPutChar(char c, FONT *f, DWORD *surface, int surfpitch, int x,int y,float size)
{
	DWORD *temp;
	void *sp;
	void *tp;
	void *sptemp;
	void *end;
	int i;
	
	if(!f || !surface)
		return 0;
	
	temp = malloc(32*((int)(f->w*size)*(int)(f->h*size)));
	if(!temp)
		return 0;

	if(c < (char)0x20)
		return 0;

	//if(c > (char)0x7f)
	//	return 0;
	
	
	if(!Hermes_ConverterRequest(converter,form,form))
	{
		printk("Hermes_ConverterRequest failed!\n");
		free(temp);
		return 0;
	}

	//we copy to a TEMPORARY buffer, and do the colorkey copying by hand
	if(!Hermes_ConverterCopy(converter,
			f->letters[c-0x20],
			0,0,
			f->w, f->h,
			f->w*f->bpp,
			
			temp,
			0,0,
			(int)(f->w*size),(int)(f->h*size),
			(int)(f->w*size)*4))
	{
		printk("Hermes_ConverterCopy failed!\n");
		free(temp);
		return 0;
	}

	sp=(void*) surface + (surfpitch * y) + (x*4);
	tp =(void*) temp;
	
	for(i=0;i < (int)(f->h*size);i++)
	{
		end = tp + (int)(f->w*size)*4 - 4;
		sptemp = sp;
		while(tp != end)
		{

			//could use a threshhold on this if, maybe?
			//such a treshhold could eliminate some
			//of the mesquitos
			
			/*//forces the font to 2color,
			if( *((int*)tp) & 0xFFFFFF)
			{
				*(int*)sp = 0xFFFFFFFF;
			}
			*/

			//uses original font colors
			if(x > 0 && y > 0 && x < 640 && y < 480)
				//if( *((int*)tp) & 0xFFFFFF )
				if ( ((
					(*((int*)tp) >> 16) |
					(*((int*)tp) << 8 >> 16) |
					(*((int*)tp) << 16 >> 16)
				     ) & 0xFF) > 0x88)
				{
					*(int*)sp = *(int*)tp;
				}
			
			tp++;
			sp++;
		}
		
		//memcpy(sp, tp, (int)(f->w*size)*4);
		//tp+=(int)(f->w*size)*4;
		sp = sptemp + surfpitch;
		tp += 4;
	}
	
	free(temp);
	return 1;
}


int bfClear(DWORD *surface,int x, int y, int w, int h, int pitch, int r, int g, int b, int a)
{
	if(!surface)
		return 0;
	
	if(!Hermes_ClearerRequest(clearer, form))
	{
		return 0;
	}

	if(!Hermes_ClearerClear(clearer,
				surface,
				x,y,
				w,h,
				pitch,
				r,g,b,a))
	{
		return 0;
	}

	return 1;

}

int bfPutStr(char *s, FONT *f, DWORD *surface, int pitch, int x, int y, float size)
{
	char *p=s;
	int cx=x;
	while(*p)
	{
		if(!bfPutChar(*p, f, surface, pitch, cx, y, size))
			return 0;
		cx+=(int)(f->w*size);
		p++;
	}
	return 1;
}


